@extends($activeTemplate . 'layouts.frontend')

@section('content')
    @php
        $loginContent = getContent('login.content', true);
    @endphp

    <section class="account">
        <div class="account-content">
            <div class="account-logo">
                <div class="container">
                    <a href="{{ route('home') }}">
                        <img src="{{ siteLogo(2) }}" alt="site-logo">
                    </a>
                </div>
            </div>
            <div class="account-form">
                <div class="row justify-content-center">
                    <div class="col-xl-6 col-lg-8 col-md-10">
                        <div class="account-form__content text-center">
                            <h2 class="account-form__title mb-2"> {{ __($loginContent->data_values->heading) }} </h2>
                            <p class="account-form__desc"> {{ __($loginContent->data_values->sub_heading) }} </p>
                        </div>
                        <form class="verify-gcaptcha" method="POST" action="{{ route('user.login') }}">
                            @csrf
                            <div class="row">
                                <div class="col-sm-12 form-group">
                                    <div class="form--group">
                                        <label class="form--label" for="email">@lang('Username or Email')</label>
                                        <input class="form--control" name="username" type="text" value="{{ old('username') }}" required>
                                    </div>
                                </div>
                                <div class="col-12 form-group">
                                    <label class="form--label" for="your-password">@lang('Password')</label>
                                    <div class="position-relative">
                                        <input class="form--control form--control" id="your-password" name="password" type="password" required>
                                        <span class="password-show-hide fas fa-eye toggle-password fa-eye-slash" id="#your-password"></span>
                                    </div>
                                </div>

                                <x-captcha />
                                <div class="col-sm-12">
                                    <div class="form-group form--check">
                                        <input class="form-check-input" id="remember" name="remember" type="checkbox" {{ old('remember') ? 'checked' : '' }}>
                                        <label class="form-check-label" for="remember">
                                            @lang('Remember Me')
                                        </label>
                                    </div>
                                </div>

                                <div class="col-sm-12 form-group">
                                    <button class="btn btn--base w-100" type="submit"> @lang('Sign In') </button>
                                </div>
                                <div class="col-sm-12">
                                    <div class="have-account text-center">
                                        <p class="have-account__text pb-2">
                                            <a href="{{ route('user.password.request') }}">
                                                @lang('Forgot your password?')
                                            </a>
                                        </p>
                                        <p class="have-account__text"> @lang('Don\'t Have An Account?') <a class="have-account__link" href="{{ route('user.register') }}"> @lang('Sign Up') </a></p>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="account-copyright">
                    <span class="fs-12 account-copyright__text">
                        @lang('Copyright') &copy; {{ date('Y') }}. @lang('All Rights Reserved By') <a class="t-link" href="{{ route('home') }}">{{ __($general->site_name) }}</a>
                    </span>
            </div>
        </div>
        <div class="account-thumb">
            <img src="{{ getImage('assets/images/frontend/login/' . @$loginContent->data_values->image, '960x965') }}">
        </div>
    </section>
@endsection
