@extends($activeTemplate . 'layouts.frontend')
@section('content')
    <section class="py-100">
        <div class="container">
            <div class="bodywrapper__inner">
                <div class="row">
                    <div class="d-flex justify-content-end mb-3">
                        <a class="submit-btn text--small" href="{{ asset('assets/example.txt') }}" target="_blank">
                            <i class="las la-code"></i>
                            Example PHP Code</a>
                    </div>
                    <div class="col-lg-12">
                        <div class="api-docs">
                            <ul class="api-docs-list">
                                <li class="api-docs-list__item"> <strong class="text"> @lang('API URL') </strong> <span
                                          class="text">{{ route('api.v1') }}</span>
                                </li>
                                <li class="api-docs-list__item"> <strong class="text"> @lang('Response Format')</strong> <span
                                          class="text">JSON</span>
                                </li>
                                <li class="api-docs-list__item"> <strong class="text"> @lang('HTTP Method')</strong> <span
                                          class="text"> POST</span>
                                </li>
                                <li class="api-docs-list__item"> <strong class="text"> @lang('Api Key')</strong> <span
                                          class="text">@lang('Your api key')</span>
                                </li>
                            </ul>
                        </div>
                    </div>

                    <div class="col-lg-12">
                        <div class="faq-wrapper">

                            <div class="faq-item">
                                <h3 class="faq-title"><span class="title">@lang('Service List')
                                    </span><span class="right-icon"></span></h3>
                                <div class="faq-content">
                                    <div class="card">
                                        <div class="card-body">
                                            <b>@lang('Required parameters')</b>

                                            <div id="type_0">
                                                <ul>
                                                    <li><b width="20%">key</b> - @lang('Your API Key')</li>
                                                    <li><b>action</b> - "services"</li>
                                                </ul>
                                            </div>
                                            <br>
                                            <b>@lang('Success response') :</b>
                                            <pre>[
    {<em>
     "service": 1,
     "name": "YouTube Livestream Viewers ",
     "rate": "0.33000000",
     "min": 1000,
     "max": 200000,
     "category": "Live Stream [ Low ConCurrent | Less Price ] [ 30 Minutes to 24 Hours]"</em>
    },
    {<em>
      "service": 2,
      "name": "YouTube Livestream Viewers ~ ",
      "rate": "2.10000000",
      "min": 1000,
      "max": 200000,
      "category": "Live Stream [ Low ConCurrent | Less Price ] [ 30 Minutes to 24 Hours]" </em>
    }
]</pre>
                                            <br>
                                            <b>@lang('Error response') :</b>
                                            <pre>
{<em>"@lang('error')" : "@lang('The action field is required')" </em>}
{<em>"@lang('error')" : "@lang('The api key field is required')" </em>}
{<em>"@lang('error')" : "@lang('Invalid api key')" </em>}
{<em>"@lang('error')" : "@lang('Invalid action')" </em>}
</pre>

                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="faq-item">
                                <h3 class="faq-title"><span class="title">@lang('Place New Order')
                                    </span><span class="right-icon"></span></h3>
                                <div class="faq-content">

                                    <div class="card">
                                        <div class="card-body">
                                            <b>@lang('Required parameters')</b>

                                            <div id="type_0">
                                                <ul>
                                                    <li><b width="20%">key</b> - @lang('Your API Key')</li>
                                                    <li><b>action</b> - "add"</li>
                                                    <li><b>service</b> - @lang('Service ID')</li>
                                                    <li><b>link</b> - @lang('Link to page')</li>
                                                    <li><b>quantity</b> - @lang('Quantity to be delivered')</li>
                                                    <li><b>runs(optional) </b> - @lang('Runs to deliver')</li>
                                                    <li><b>interval(optional) </b> - @lang('Interval in minutes')</li>
                                                </ul>
                                            </div>
                                            <br>
                                            <b>@lang('Success response') :</b>
                                            <pre>
{<em>
  "order" : "1242"</em> 
}
</pre>

                                            <br>
                                            <b>@lang('Error response') :</b>
                                            <pre>
{<em>"@lang('error')" : "@lang('The action field is required')"</em>}
{<em>"@lang('error')" : "@lang('The api key field is required')"</em>}
{<em>"@lang('error')" : "@lang('Invalid api key')"</em>}
{<em>"@lang('error')" : "@lang('Invalid Service Id')"</em>}
{<em>"@lang('error')" : "@lang('The link field is required')"</em>}
{<em>"@lang('error')" : "@lang('The quantity field is required')"</em>}
{<em>"@lang('error')" : "@lang('Please follow the limit')"</em>}
{<em>"@lang('error')" : "@lang('Insufficient balance')"</em>}

</pre>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <div class="faq-item">
                                <h3 class="faq-title"><span class="title">
                                        @lang('Order Status')
                                    </span><span class="right-icon"></span></h3>
                                <div class="faq-content">

                                    <div class="card">
                                        <div class="card-body">
                                            <b>@lang('Required parameters')</b>

                                            <div id="type_0">
                                                <ul>
                                                    <li><b width="20%">key</b> - @lang('Your API Key')</li>
                                                    <li><b>action</b> - "status"</li>
                                                    <li><b>order</b> - @lang('Order ID')</li>
                                                </ul>
                                            </div>
                                            <br>
                                            <b>@lang('Success response') :</b>
                                            <pre>
{<em>
  "status" : "Pending",
  "start_count" : "1000",
  "remains" : "500",
  "currency" : {{ gs()->cur_text }}
</em>
}</pre>
                                            <br>
                                            <b>@lang('Available status')</b>
                                            <ul>
                                                <li><span class="text--warning">Pending</span></li>
                                                <li><span class="text--info">Processing</span></li>
                                                <li><span class="text--success">Complete</span></li>
                                                <li><span class="text--danger">Order Cancelled</span></li>
                                                <li><span class="text--dark">Refunded</span></li>
                                            </ul>
                                            <br>
                                            <b>@lang('Error response') :</b>
                                            <pre>
{<em>"@lang('error')" : "@lang('The action field is required')"</em>}
{<em>"@lang('error')" : "@lang('The api key field is required')"</em>}
{<em>"@lang('error')" : "@lang('Invalid api key')"</em>}
{<em>"@lang('error')" : "@lang('Invalid request')"</em>}
{<em>"@lang('error')" : "@lang('The order field is required')"</em>}
{<em>"@lang('error')" : "@lang('Invalid Order Id')"</em>}
 </pre>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <div class="faq-item">
                                <h3 class="faq-title"><span class="title">@lang('Order Refill')
                                    </span><span class="right-icon"></span></h3>
                                <div class="faq-content">

                                    <div class="card">
                                        <div class="card-body">
                                            <b>@lang('Required parameters')</b>

                                            <div id="type_0">
                                                <ul>
                                                    <li><b width="20%">key</b> - @lang('Your API Key')</li>
                                                    <li><b>action</b> - "refill"</li>
                                                    <li><b>Order</b> - @lang('Order ID')</li>
                                                </ul>
                                            </div>
                                            <br>
                                            <b>@lang('Success response') :</b>
                                            <pre>
{<em>
   "success": "Your order will be refill asap. Thank you for patience",
   "refill": 12345</em>
}
 </pre>
                                            <br>
                                            <b>@lang('Error response') :</b>
                                            <pre>
{<em>"@lang('error')" : "@lang('Order not eligible for refill.')"</em>}
 </pre>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <div class="faq-item">
                                <h3 class="faq-title"><span class="title">
                                        @lang('Get Refill Status')
                                    </span><span class="right-icon"></span></h3>
                                <div class="faq-content">

                                    <div class="card">
                                        <div class="card-body">
                                            <b>@lang('Required parameters')</b>

                                            <div id="type_0">
                                                <ul>
                                                    <li><b width="20%">key</b> - @lang('Your API Key')</li>
                                                    <li><b>action</b> - "refill_status"</li>
                                                    <li><b>refill</b> - @lang('Refill ID')</li>
                                                </ul>
                                            </div>
                                            <br>
                                            <b>@lang('Success response') :</b>
                                            <pre>
{
  <em>
    "status": "Completed",
</em>
}
 </pre>
                                        </div>
                                    </div>

                                </div>
                            </div>

                            <div class="faq-item">
                                <h3 class="faq-title"><span class="title">
                                        @lang('Get Balance')
                                    </span><span class="right-icon"></span></h3>
                                <div class="faq-content">

                                    <div class="card">
                                        <div class="card-body">
                                            <b>@lang('Required parameters')</b>

                                            <div id="type_0">
                                                <ul>
                                                    <li><b width="20%">key</b> - @lang('Your API Key')</li>
                                                    <li><b>action</b> - "balance"</li>

                                                </ul>
                                            </div>
                                            <br>
                                            <b>@lang('Success response') :</b>
                                            <pre>
{<em>"balance" : "100.84292"</em>
<em>"currency" : {{ gs()->cur_text }}</em>
}
  </pre>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@push('style')
    <style>
        .submit-btn {
            padding: 10px 25px;
            color: white;
            background-color: #4d5bed;
            border-radius: 5px;
            font-size: 17px;
            font-weight: 500;
        }

        .submit-btn:hover {
            color: #ffffff;
        }

        .api-docs-list__item {
            color: #000;
            display: flex;
            justify-content: space-between;
            flex-wrap: wrap;
            border-bottom: 1px solid #ddd;
            padding: 15px;
            gap: 10px;
        }

        .api-docs-list {
            border: 1px solid #ddd;
            border-radius: 5px;
        }

        .api-docs-list__item .text {
            flex-basis: 48%;
            word-wrap: break-word !important;
            max-width: -webkit-fill-available;
            word-break: break-all;
        }

        @media (max-width: 424px) {
            .api-docs-list__item .text {
                flex-basis: 100%;
            }
        }

        .api-docs-list__item:last-child {
            border-bottom: 0;
        }

        .faq-section {
            background-image: -webkit-linear-gradient(30deg, #f7f8fa 0%, #f0f1fa 100%);
            background-image: -ms-linear-gradient(30deg, #f7f8fa 0%, #f0f1fa 100%);
            position: relative;
            overflow: hidden;
            z-index: 1;
        }

        .faq-section:hover .highlight-background--lean-left {
            left: 20%;
        }

        .faq-thumb {
            animation: giraffe2 3s linear infinite;
        }

        .faq-wrapper {
            margin-top: 30px;
        }

        .faq-wrapper .faq-item {
            transition: all 0.3s;
        }

        .faq-wrapper .faq-item:not(:last-child) {
            margin-bottom: 20px;
        }

        .faq-wrapper .faq-item .faq-title {
            font-size: 20px;
            text-transform: unset;
            align-items: center;
            cursor: pointer;
            display: flex;
            flex-wrap: wrap;
            align-items: center;
            background: white;
            border: 1px solid #e5e5e5;
            border-radius: 5px;
            background-color: #0c20500f;
            margin-bottom: 0;
        }

        .faq-wrapper .faq-item .faq-title .title {
            width: calc(100% - 40px);
            padding: 15px 30px;
            display: inline-block;
            font-size: 18px;
            font-weight: 600;
            margin-bottom: 0;
            text-transform: unset;
        }

        .faq-content {
            margin-top: 20px;
        }

        .faq-wrapper .faq-item.open .faq-title {
            background: #4d5bed;
            color: white;
        }

        .faq-wrapper .faq-item.open .right-icon::before {
            background-color: white;
            -webkit-transform: translate(-50%, -50%) rotate(90deg);
            -ms-transform: translate(-50%, -50%) rotate(90deg);
            transform: translate(-50%, -50%) rotate(90deg);
        }

        .faq-wrapper .faq-item.open .right-icon::after {
            background-color: white;
        }

        .faq-wrapper .faq-item.active .faq-content {
            display: block;
        }

        .faq-wrapper .faq-item.active.open .right-icon::before {
            -webkit-transform: translate(-50%, -50%) rotate(90deg);
            -ms-transform: translate(-50%, -50%) rotate(90deg);
            transform: translate(-50%, -50%) rotate(90deg);
        }

        .faq-wrapper .faq-content {
            display: none;
        }

        .faq-wrapper .faq-content p {
            margin-top: 25px;
            text-transform: unset;
        }

        .faq-wrapper .faq-content p:last-child {
            margin-bottom: -7px;
        }

        .faq-wrapper .right-icon {
            display: block;
            width: 35px;
            height: 35px;
            position: relative;
            right: 20px;
        }

        .faq-wrapper .right-icon::before,
        .faq-wrapper .right-icon::after {
            position: absolute;
            content: '';
            background: #232323;
            -webkit-transition: all ease 0.3s;
            -moz-transition: all ease 0.3s;
            transition: all ease 0.3s;
            -webkit-transform: translate(-50%, -50%);
            -ms-transform: translate(-50%, -50%);
            transform: translate(-50%, -50%);
        }

        .faq-wrapper .right-icon::before {
            width: 2px;
            height: 16px;
            top: 50%;
            left: 50%;
        }

        .faq-wrapper .right-icon::after {
            width: 16px;
            height: 2px;
            top: 50%;
            left: 50%;
        }
    </style>
@endpush

@push('script')
    <script>
        $(".faq-wrapper .faq-title").on("click", function(e) {
            var element = $(this).parent(".faq-item");
            if (element.hasClass("open")) {
                element.removeClass("open");
                element.find(".faq-content").removeClass("open");
                element.find(".faq-content").slideUp(300, "swing");
            } else {
                element.addClass("open");
                element.children(".faq-content").slideDown(300, "swing");
                element
                    .siblings(".faq-item")
                    .children(".faq-content")
                    .slideUp(300, "swing");
                element.siblings(".faq-item").removeClass("open");
                element.siblings(".faq-item").find(".faq-title").removeClass("open");
                element.siblings(".taq-item").find(".faq-content").slideUp(300, "swing");
            }
        });

        $(".faq-wrapper--style .faq-title").on("click", function(e) {
            var element = $(this).parent(".faq-item--style");
            if (element.hasClass("open")) {
                element.removeClass("open");
                element.find(".faq-content--style").removeClass("open");
                element.find(".faq-content--style").slideUp(300, "swing");
            } else {
                element.addClass("open");
                element.children(".faq-content--style").slideDown(300, "swing");
                element
                    .siblings(".faq-item--style")
                    .children(".faq-content--style")
                    .slideUp(300, "swing");
                element.siblings(".faq-item--style").removeClass("open");
                element
                    .siblings(".faq-item--style")
                    .find(".faq-title")
                    .removeClass("open");
                element
                    .siblings(".taq-item--style")
                    .find(".faq-content--style")
                    .slideUp(300, "swing");
            }
        });
    </script>
@endpush
