<?php

namespace App\Http\Middleware;

use Auth;
use Closure;

class CheckStatus
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {

        if (Auth::check()) {
            $user = auth()->user();

            if ($user->status && $user->ev && $user->sv && $user->tv) {
                return $next($request);
            } else {
                return to_route('user.authorization');
            }
        }

        abort(403);
    }
}